# 🚀 راهنمای سریع: رفع مشکل دکمه ذخیره آدرس سرور

## ✅ مشکلات حل شده:

### ۱. خطای JavaScript در صفحه index.php
```
Uncaught TypeError: Cannot read properties of null
```
**حل شد!** ✅

### ۲. دکمه "ذخیره آدرس سرور" کار نمی‌کرد
**حل شد!** ✅

---

## 🔄 مراحل آپدیت Extension:

### مرحله ۱: Reload Extension

1. به `chrome://extensions/` بروید
2. Extension "Google Maps Scraper Pro" را پیدا کنید
3. روی آیکون **🔄 Reload** (در پایین کارت extension) کلیک کنید

**مهم:** اگر Extension باز بود، آن را ببندید و دوباره باز کنید.

---

### مرحله ۲: تنظیم آدرس سرور

1. روی آیکون Extension در نوار ابزار Chrome کلیک کنید

2. در بخش **⚙️ تنظیمات سرور** این آدرس را وارد کنید:

   ```
   https://web.officebaz.ir/google_map_data
   ```

3. روی دکمه **💾 ذخیره آدرس سرور** کلیک کنید

4. باید یک **Toast Notification** ببینید:
   ```
   ✅ تنظیمات با موفقیت ذخیره شد
   ```

5. همچنین یک **Chrome Notification** نمایش داده می‌شود:
   ```
   تنظیمات ذخیره شد
   آدرس سرور با موفقیت تغییر کرد
   ```

---

### مرحله ۳: تست اتصال

#### روش ۱: از طریق Console Extension

1. به `chrome://extensions/` بروید
2. روی لینک **service worker** کلیک کنید
3. Console باز می‌شود
4. باید ببینید:

```javascript
✅ Loaded server URL from storage: https://web.officebaz.ir/google_map_data
🚀 Service worker started
🔧 Extension installed/updated
```

#### روش ۲: از طریق صفحه تست

1. صفحه تست را باز کنید:
   ```
   https://web.officebaz.ir/google_map_data/test_extension_connection.php
   ```

2. این صفحه نشان می‌دهد:
   - ✅ آدرس سرور فعلی
   - ✅ Job های در انتظار در دیتابیس
   - ✅ Store ID شما
   - ✅ وضعیت اتصال دیتابیس

---

### مرحله ۴: تست کامل

1. به صفحه اصلی بروید:
   ```
   https://web.officebaz.ir/google_map_data/index.php
   ```

2. F12 را بزنید و Console را باز کنید

3. یک search tag وارد کنید (مثلاً "فلافل")

4. روی **دریافت داده** کلیک کنید

5. در Console باید ببینید:
   ```javascript
   🌐 Base path detected: (root)
   Checking subscription before Google Map data processing for: فلافل
   🔍 Checking device limit at: /api/check-device-limit.php
   Job created successfully
   SweetAlert is available
   Polling for completion...
   ```

6. در Console Extension (service worker) باید ببینید:
   ```javascript
   🔄 Polling for jobs...
   ✅ Found job: فلافل
   🚀 Starting scraping...
   ```

---

## 🐛 عیب‌یابی

### ❌ هنوز Toast نشان داده نمی‌شود؟

**راه حل:**
1. Extension را Disable کنید
2. سپس دوباره Enable کنید
3. Popup را ببندید و دوباره باز کنید

### ❌ هنوز آدرس ذخیره نمی‌شود؟

**بررسی Console Popup:**
1. روی popup راست کلیک کنید
2. "Inspect" را انتخاب کنید
3. به تب Console بروید
4. روی دکمه ذخیره کلیک کنید
5. خطاها را بررسی کنید

### ❌ Extension هنوز به لوکال متصل است؟

**راه حل:**
1. Console Extension را باز کنید
2. این دستور را اجرا کنید:
   ```javascript
   chrome.storage.local.set({ serverUrl: 'https://web.officebaz.ir/google_map_data' }, () => {
     console.log('✅ Manually set server URL');
   });
   ```
3. Extension را Reload کنید

---

## 📊 چک‌لیست نهایی

قبل از استفاده:

- [ ] Extension reload شده است
- [ ] Popup باز و بسته شده است
- [ ] آدرس سرور وارد شده: `https://web.officebaz.ir/google_map_data`
- [ ] دکمه ذخیره کلیک شده است
- [ ] Toast notification نشان داده شده است
- [ ] Chrome notification نشان داده شده است
- [ ] Console Extension خطا ندارد
- [ ] سرور فعلی در popup صحیح است
- [ ] لینک "باز کردن پنل" به آدرس صحیح می‌رود

---

## 🎯 انتظار می‌رود:

### در Popup:
```
⚙️ تنظیمات سرور:
[https://web.officebaz.ir/google_map_data]
[💾 ذخیره آدرس سرور]

سرور فعلی: https://web.officebaz.ir/google_map_data
```

### در Console Extension:
```
✅ Loaded server URL from storage: https://web.officebaz.ir/google_map_data
🚀 Service worker started
🔄 Polling for jobs...
```

### وقتی دکمه ذخیره را می‌زنید:
```
✅ Server URL updated to: https://web.officebaz.ir/google_map_data
```

---

## ✨ آماده است!

Extension حالا باید کامل کار کند. اگر هنوز مشکلی هست، صفحه تست اتصال را بررسی کنید:

```
https://web.officebaz.ir/google_map_data/test_extension_connection.php
```

---

**موفق باشید! 🚀**

