# 🚀 راهنمای نصب و راه‌اندازی Google Maps Scraper Extension

## 📋 مراحل نصب

### گام ۱: دانلود Extension
فایل‌های extension در پوشه فعلی موجود است.

### گام ۲: نصب Extension در Chrome

1. مرورگر Chrome را باز کنید
2. به آدرس `chrome://extensions/` بروید
3. گزینه **Developer mode** را در گوشه بالا سمت راست فعال کنید
4. روی دکمه **Load unpacked** کلیک کنید
5. پوشه extension را انتخاب کنید
6. Extension نصب شد! ✅

---

## ⚙️ تنظیمات Extension

### 🔴 مهم: تنظیم آدرس سرور

Extension باید به سرور شما متصل شود. دو حالت وجود دارد:

#### 🏠 برای استفاده در لوکال:
```
http://localhost/wa/google_map_data
```

#### 🌐 برای استفاده در سرور آنلاین:
```
https://web.officebaz.ir/google_map_data
```

---

## 📝 نحوه تنظیم آدرس سرور:

### روش ۱: از طریق Popup Extension

1. روی آیکون Extension در Chrome کلیک کنید
2. در بخش **⚙️ تنظیمات سرور** آدرس سرور خود را وارد کنید:
   - لوکال: `http://localhost/wa/google_map_data`
   - آنلاین: `https://web.officebaz.ir/google_map_data`
3. روی دکمه **💾 ذخیره آدرس سرور** کلیک کنید
4. پیام تاییدیه نشان داده خواهد شد ✅

### روش ۲: تغییر مستقیم در کد (برای سرور ثابت)

اگر همیشه از یک سرور استفاده می‌کنید، می‌توانید مستقیماً آدرس را در کد تغییر دهید:

**فایل: `background.js`**
```javascript
// خط ۱ را تغییر دهید:
const BASE = "https://web.officebaz.ir/google_map_data";
```

---

## 🔧 بررسی وضعیت اتصال

### ۱. باز کردن Developer Console برای Extension:

1. به `chrome://extensions/` بروید
2. Extension را پیدا کنید
3. روی لینک **service worker** یا **background page** کلیک کنید
4. کنسول باز می‌شود

### ۲. پیام‌های مهم در Console:

```javascript
✅ Extension loaded with dynamic server support
📍 Default BASE: https://web.officebaz.ir/google_map_data
🚀 Service worker started
🔧 Extension installed/updated
```

### ۳. تست دستی اتصال:

در کنسول Extension این کد را اجرا کنید:

```javascript
fetch('https://web.officebaz.ir/google_map_data/get_job.php', {
  credentials: 'include'
})
  .then(r => r.json())
  .then(data => console.log('✅ Connection test:', data))
  .catch(err => console.error('❌ Connection failed:', err));
```

---

## 🎯 نحوه استفاده

### مرحله ۱: ایجاد Job در پنل وب

1. به پنل وب بروید:
   - لوکال: `http://localhost/wa/google_map_data`
   - آنلاین: `https://web.officebaz.ir/google_map_data`

2. یک search tag وارد کنید (مثلاً "فلافل")

3. اگر نیاز است، محدوده جغرافیایی را روی نقشه انتخاب کنید

4. روی دکمه **دریافت داده** کلیک کنید

5. صفحه منتظر می‌ماند تا Extension کار خود را انجام دهد

### مرحله ۲: Extension به طور خودکار کار می‌کند

1. Extension هر چند ثانیه یک بار سرور را چک می‌کند
2. وقتی Job جدیدی پیدا کند، شروع به استخراج می‌کند
3. نتایج را به سرور می‌فرستد
4. در نهایت صفحه وب به صورت خودکار به صفحه نتایج منتقل می‌شود

---

## 🐛 عیب‌یابی

### ❌ Extension کار نمی‌کند؟

#### چک‌لیست:

1. **Extension فعال است؟**
   - به `chrome://extensions/` بروید
   - مطمئن شوید toggle آن روشن است

2. **آدرس سرور درست است؟**
   - Popup extension را باز کنید
   - در قسمت "سرور فعلی" آدرس را بررسی کنید
   - باید دقیقاً با آدرس پنل وب مطابقت داشته باشد

3. **Permission ها داده شده است؟**
   - Extension نیاز به دسترسی به Google Maps و سرور شما دارد
   - در صورت درخواست permission، آن را تایید کنید

4. **Console خطا نشان می‌دهد؟**
   - کنسول Extension را باز کنید
   - خطاهای قرمز را بررسی کنید
   - معمولاً CORS یا Network errors هستند

### ⚠️ خطاهای رایج:

#### CORS Error:
```
Access to fetch at '...' from origin 'chrome-extension://...' has been blocked by CORS policy
```

**راه حل:** 
- در فایل‌های PHP سرور، header های CORS اضافه شده است
- اطمینان حاصل کنید `get_job.php` این header ها را دارد:

```php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Credentials: true');
```

#### Network Error:
```
Failed to fetch
```

**راه حل:**
- مطمئن شوید سرور در دسترس است
- آدرس سرور را در extension دوباره بررسی کنید
- اگر HTTPS است، گواهی SSL معتبر باشد

---

## 🔄 آپدیت Extension

اگر تغییراتی در کد دادید:

1. به `chrome://extensions/` بروید
2. روی آیکون 🔄 (Reload) extension کلیک کنید
3. یا کلید `Ctrl+R` را در صفحه extensions بزنید

---

## 📊 مانیتورینگ

### نمایش پیشرفت کار:

- Popup extension را باز کنید
- پیشرفت real-time استخراج را ببینید:
  - 📊 کل: تعداد کل نتایج
  - ✅ استخراج شده: تعداد پردازش شده
  - ⏭️ رد شده: تعداد تکراری یا خطا

### دکمه‌های کنترل:

- **⏸️ توقف**: مکث موقت استخراج
- **▶️ ادامه**: ادامه استخراج
- **⏹️ لغو**: لغو کامل job

---

## 💡 نکات مهم

1. **Extension باید همیشه باز باشد**
   - مرورگر Chrome باید در حال اجرا باشد
   - Extension باید enable باشد

2. **یک Job در هر زمان**
   - Extension یک job را در هر لحظه پردازش می‌کند
   - اگر چند job ایجاد کنید، به ترتیب پردازش می‌شوند

3. **سرعت استخراج**
   - برای جلوگیری از block شدن، extension با delay کار می‌کند
   - استخراج 100-500 نتیجه ممکن است چند دقیقه طول بکشد

4. **حریم خصوصی**
   - Extension فقط به Google Maps و سرور شما دسترسی دارد
   - هیچ اطلاعاتی ذخیره یا به جای دیگری ارسال نمی‌شود

---

## 🆘 پشتیبانی

در صورت بروز مشکل:

1. صفحه تست اتصال را باز کنید:
   ```
   https://web.officebaz.ir/google_map_data/test_extension_connection.php
   ```

2. نتایج تست را بررسی کنید

3. برای پشتیبانی تماس بگیرید:
   - 🌐 وب‌سایت: https://officebaz.ir
   - 📱 واتساپ: +91 73599 15669

---

## ✅ چک‌لیست نهایی

قبل از شروع کار، این موارد را بررسی کنید:

- [ ] Extension نصب و فعال است
- [ ] آدرس سرور صحیح تنظیم شده است
- [ ] Console extension خطایی ندارد
- [ ] وب‌سایت در دسترس است
- [ ] لاگین کرده‌اید (session فعال است)
- [ ] تست اتصال موفق بوده است

✨ **حالا آماده استفاده هستید!** ✨

