# ⚠️ مشکل: Extension با localhost کار می‌کند ولی با سرور آنلاین نه!

## 🔴 علت اصلی مشکل:

شما احتمالاً آدرس سرور را با **`http://`** نوشتید، در حالی که باید **`https://`** باشد!

---

## ✅ راه‌حل (۳۰ ثانیه):

### قدم ۱: آدرس صحیح را کپی کنید

```
https://web.officebaz.ir/google_map_data
```

**توجه:** 
- ✅ با `https://` شروع می‌شود (نه `http://`)
- ✅ **بدون** اسلش در آخر
- ✅ **بدون** `www`

### قدم ۲: در Extension وارد کنید

1. Extension را باز کنید
2. در کادر **⚙️ تنظیمات سرور** آدرس بالا را Paste کنید
3. روی **💾 ذخیره آدرس سرور** کلیک کنید
4. باید Toast نمایش داده شود: "✅ تنظیمات با موفقیت ذخیره شد"

### قدم ۳: Extension را Reload کنید

1. به `chrome://extensions/` بروید
2. روی 🔄 کلیک کنید
3. Console Extension را باز کنید (service worker)
4. باید ببینید:
   ```
   ✅ Loaded server URL from storage: https://web.officebaz.ir/google_map_data
   ```

---

## 🧪 صفحه تست

برای اطمینان، این صفحه را باز کنید:

```
https://web.officebaz.ir/google_map_data/test_connection_detailed.php
```

این صفحه:
- ✅ آدرس صحیح را نشان می‌دهد
- ✅ همه API ها را تست می‌کند
- ✅ کد تست برای Console Extension می‌دهد
- ✅ دکمه کپی برای آدرس صحیح دارد

---

## 📋 مقایسه آدرس‌ها:

| محیط | آدرس صحیح | Protocol |
|------|-----------|----------|
| لوکال | `http://localhost/wa/google_map_data` | HTTP ✅ |
| آنلاین | `https://web.officebaz.ir/google_map_data` | HTTPS ✅ |

**نکته مهم:** لوکال با `http` و آنلاین با `https`!

---

## ❌ آدرس‌های نادرست (استفاده نکنید):

```
❌ http://web.officebaz.ir/google_map_data/    (http نه https)
❌ https://web.officebaz.ir/google_map_data/   (اسلش اضافی)
❌ http://web.officebaz.ir/google_map_data     (http نه https)
❌ https://www.officebaz.ir/google_map_data    (www اضافی)
```

---

## 🔍 چطور فهمیدم مشکل از کجاست؟

### در Console Extension:

**اگر آدرس نادرست است:**
```javascript
❌ Failed to fetch
❌ net::ERR_CONNECTION_REFUSED
❌ Mixed Content Error
❌ CORS Error
```

**اگر آدرس درست است:**
```javascript
✅ Loaded server URL from storage: https://...
✅ Polling for jobs...
✅ Fetching job from: https://...
```

---

## 💡 نکات اضافی:

### ۱. Mixed Content Error

اگر صفحه وب HTTPS است ولی Extension می‌خواهد به HTTP متصل شود:

```
❌ Mixed Content: The page at 'https://...' was loaded over HTTPS,
   but requested an insecure resource 'http://...'.
```

**راه حل:** همیشه از HTTPS استفاده کنید.

### ۲. SSL Certificate

اگر سرور SSL معتبر ندارد، Extension ممکن است اتصال را رد کند.

**بررسی:** صفحه را در مرورگر باز کنید:
```
https://web.officebaz.ir/google_map_data/get_job.php
```

اگر مرورگر هشدار SSL می‌دهد، باید certificate را برطرف کنید.

### ۳. Port مخفی

HTTPS معمولاً روی port 443 است. اگر سرور شما port دیگری دارد:

```
✅ https://web.officebaz.ir:8443/google_map_data
```

---

## 🎯 چک‌لیست نهایی:

قبل از تست، مطمئن شوید:

- [ ] آدرس با `https://` شروع می‌شود
- [ ] بدون اسلش در آخر است
- [ ] در Extension ذخیره شده است
- [ ] Toast notification نشان داده شد
- [ ] Extension reload شده است
- [ ] Console Extension خطا ندارد
- [ ] صفحه تست سبز است

---

## 🚀 تست نهایی:

### در Console Extension این کد را اجرا کنید:

```javascript
chrome.storage.local.get(['serverUrl'], (result) => {
  console.log('📍 Current server URL:', result.serverUrl);
  
  // Test connection
  fetch(result.serverUrl + '/get_job.php', {
    credentials: 'include'
  })
    .then(r => {
      console.log('✅ Connection test:', r.status, r.statusText);
      return r.json();
    })
    .then(data => console.log('✅ Response:', data))
    .catch(err => console.error('❌ Error:', err));
});
```

**انتظار می‌رود:**
```javascript
📍 Current server URL: https://web.officebaz.ir/google_map_data
✅ Connection test: 200 OK
✅ Response: {success: false} // یا true اگر job داشته باشید
```

---

## ✨ حل شد؟

اگر همه چیز سبز شد:
- ✅ آدرس صحیح ذخیره شده
- ✅ Extension متصل است
- ✅ API ها پاسخ می‌دهند
- ✅ آماده استفاده است

**حالا می‌توانید استفاده کنید!** 🎉

---

## 🆘 هنوز کار نمی‌کند؟

اگر با آدرس صحیح هم کار نکرد، احتمالات:

1. **Firewall سرور:** Extension را block می‌کند
2. **CloudFlare/CDN:** درخواست‌های Extension را مسدود می‌کند
3. **Session:** لاگین نیستید (در صفحه وب لاگین کنید)
4. **Permissions:** Extension به دامنه شما دسترسی ندارد

برای حل، صفحه تست را بررسی کنید و خروجی Console را ارسال کنید.

---

**موفق باشید! 🚀**

