# 🔒 نسخه Production - آدرس سرور ثابت

## ✅ تغییرات انجام شده

Extension حالا به صورت **Production** تنظیم شده است:

### ۱. آدرس سرور ثابت شده ✅

**فایل:** `background.js`

```javascript
// ⚠️ IMPORTANT: This is the fixed server URL - DO NOT CHANGE!
const BASE = "https://web.officebaz.ir/google_map_data";
```

**نتیجه:**
- ✅ آدرس سرور به صورت ثابت در کد است
- ✅ کاربران نمی‌توانند آن را تغییر دهند
- ✅ نیازی به تنظیمات اولیه نیست

---

### ۲. UI ساده‌تر شده ✅

**قبل:**
```
⚙️ تنظیمات سرور:
[____________________]
[💾 ذخیره آدرس سرور]
```

**بعد:**
```
🌐 سرور متصل:
https://web.officebaz.ir/google_map_data
🔒 آدرس سرور ثابت است و قابل تغییر نیست
```

**نتیجه:**
- ✅ فقط نمایش آدرس سرور (read-only)
- ✅ کاربران نمی‌توانند تغییرش دهند
- ✅ رابط کاربری ساده‌تر

---

### ۳. حذف کدهای غیرضروری ✅

- ❌ حذف شد: تابع ذخیره آدرس سرور
- ❌ حذف شد: بارگذاری از storage
- ❌ حذف شد: Message handler برای تغییر سرور
- ✅ باقی ماند: فقط نمایش آدرس (read-only)

---

## 🚀 نحوه استفاده

### برای کاربران نهایی:

1. Extension را نصب کنید
2. هیچ تنظیماتی لازم نیست! ✅
3. به صورت خودکار به `https://web.officebaz.ir/google_map_data` متصل می‌شود
4. شروع به استفاده کنید

**هیچ قدم اضافی لازم نیست!** 🎉

---

## 🔧 برای Developer ها

### تغییر آدرس سرور (فقط برای Developer):

اگر نیاز به تغییر آدرس سرور دارید:

1. فایل `background.js` را باز کنید
2. خط 2 را تغییر دهید:

```javascript
const BASE = "https://your-domain.com/path-to-api";
```

3. Extension را در Chrome reload کنید
4. آماده است!

---

## 📦 توزیع Extension

### مرحله ۱: ایجاد فایل ZIP

```bash
cd extension/
zip -r GoogleMapsScraper-Production.zip . -x "*.md" -x "background_dynamic.js"
```

یا در Windows:
- همه فایل‌های پوشه `extension` را انتخاب کنید
- روی آن‌ها راست کلیک کنید
- Send to → Compressed (zipped) folder

### مرحله ۲: توزیع

**گزینه A: Chrome Web Store**
1. به [Chrome Web Store Developer Dashboard](https://chrome.google.com/webstore/devconsole) بروید
2. فایل ZIP را آپلود کنید
3. اطلاعات Extension را پر کنید
4. منتشر کنید

**گزینه B: توزیع خصوصی**
1. فایل ZIP را به کاربران بدهید
2. کاربران باید:
   - فایل را Extract کنند
   - به `chrome://extensions/` بروند
   - Developer mode را فعال کنند
   - Load unpacked را کلیک کنند
   - پوشه Extract شده را انتخاب کنند

---

## ✅ مزایای نسخه Production

### 🔒 امنیت بیشتر
- کاربران نمی‌توانند به سرور دیگری متصل شوند
- جلوگیری از اشتباهات کاربری
- جلوگیری از حملات Phishing

### 🎯 سادگی استفاده
- بدون نیاز به تنظیمات اولیه
- نصب و استفاده فوری
- کمتر سردرگمی برای کاربران

### 🚀 بهینه‌سازی
- کد کمتر = سرعت بیشتر
- حذف بخش‌های غیرضروری
- کاهش حجم Extension

---

## 🔄 بازگشت به نسخه Development

اگر می‌خواهید دوباره قابلیت تغییر سرور را فعال کنید:

1. از فایل‌های پشتیبان استفاده کنید
2. یا از فایل `background_dynamic.js` استفاده کنید:

```bash
cp background_dynamic.js background.js
```

---

## 📊 مقایسه نسخه‌ها

| ویژگی | Development | Production |
|-------|-------------|------------|
| تغییر سرور | ✅ بله | ❌ خیر |
| تنظیمات UI | ✅ دارد | ❌ ندارد |
| آدرس ثابت | ❌ خیر | ✅ بله |
| آماده توزیع | ❌ خیر | ✅ بله |
| برای کاربر نهایی | ❌ خیر | ✅ بله |

---

## 🎯 توصیه‌ها

### برای Production:
- ✅ همیشه از HTTPS استفاده کنید
- ✅ آدرس را بدون اسلش در آخر بنویسید
- ✅ قبل از انتشار، کامل تست کنید
- ✅ نسخه را در `manifest.json` آپدیت کنید

### قبل از انتشار:
```json
{
  "version": "2.1",
  "name": "Google Maps Scraper Pro",
  "description": "سیستم پیشرفته استخراج اطلاعات از گوگل مپ"
}
```

---

## ✨ نتیجه

Extension حالا آماده استفاده در Production است:
- 🔒 آدرس سرور ثابت
- 🎯 رابط ساده
- 🚀 آماده توزیع

**کاربران شما فقط نصب کنند و استفاده کنند!** 🎉

---

## 📞 پشتیبانی

- 🌐 وب‌سایت: https://officebaz.ir
- 📱 واتساپ: +91 73599 15669

**موفق باشید!** 🚀

