<?php
/**
 * Uninstall script for WooCommerce WhatsApp Sender (OfficeBaz)
 * 
 * This file is executed when the plugin is uninstalled.
 * It removes all plugin data from the database.
 */

// Prevent direct access
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Remove plugin options
delete_option('wc_whatsapp_sender_options');

// Remove any WhatsApp-related meta data from orders (optional)
global $wpdb;
$wpdb->query("DELETE FROM {$wpdb->postmeta} WHERE meta_key LIKE '%whatsapp%'");

// Remove any WhatsApp-related user meta (optional)
$wpdb->query("DELETE FROM {$wpdb->usermeta} WHERE meta_key LIKE '%whatsapp%'");

// Log the uninstall action (optional)
error_log('WooCommerce WhatsApp Sender (OfficeBaz) plugin uninstalled successfully');
